﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Oświadczenie ZUS Z-10</title>
		<script runat="server">

    public class PrnParams: Soneta.Business.ContextBase {

        public PrnParams(Context context): base(context) {
        }

        string rachBank;
        [Priority(60)]
        [Caption("Rachunek bankowy")]
        public string RachBank {
            get { return rachBank; }
            set {
                rachBank = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListRachBank() {
            List<string> list = new List<string>();

            PracHistoria ph = (PracHistoria)Context[typeof(PracHistoria)];
            Soneta.Business.View v = ph.Pracownik.Rachunki.CreateView();
            v.Sort = "Priorytet";
            foreach (RachunekBankowyPracownika rbp in v)
                if (!rbp.Blokada)
                    list.Add(rbp.Rachunek.ToString());

            return list;
        }
    }

    PrnParams pars;
    [Soneta.Business.Context(Required=true)]
    public PrnParams Params {
        set { 
            pars = value;
        }
    }

    string NBSP(string ss) {
		return ss=="" ? "&nbsp;" : ss;
    }

    void LiczDanePracownika(PracHistoria ph) {
        bool dowod = ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
        if (ph.NIP == "" || ph.PESEL == "") {
            DOKRODZAJ.EditValue = dowod ? "1" : "2";
            DOKUBEZP.EditValue = ph.Dokument.SeriaNumer;
        }
        else {
            DOKRODZAJ.EditValue = NBSP("");
            DOKUBEZP.EditValue = NBSP("");
        }
        Date ur = ph.Urodzony.Data;
        if (ur != Date.Empty)
            URODZONY.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
        IAdres adres = !ph.AdresZamieszkania.IsEmpty() ? ph.AdresZamieszkania : ph.AdresZameldowania;
        AdresKodPocztowyS.EditValue = adres.KodPocztowyS;
        AdresPoczta.EditValue = adres.Poczta;
        AdresGmina.EditValue = adres.Gmina;
        AdresMiejscowosc.EditValue = adres.Miejscowosc;
        AdresUlica.EditValue = adres.Ulica;
        AdresNrDomu.EditValue = adres.NrDomu;
        AdresNrLokalu.EditValue = adres.NrLokalu;
        AdresTelefon.EditValue = adres.Telefon;
        AdresKodKraju.EditValue = adres.KodKraju;
        AdresZagranicznyKodPocztowy.EditValue = adres.ZagranicznyKodPocztowy;
        AdresKraj.EditValue = adres.Kraj;
        AdresMail.EditValue = "";
        //if (ph.Pracownik.DomyslnyRachunek != null)
        //    RachunekBank.EditValue = ph.Pracownik.DomyslnyRachunek;
        //else
        //    RachunekBank.EditValue = "&nbsp;";
    }
		
    void OnContextLoad(Object sender, EventArgs args) {
        dc.LeftMargin = dc.TopMargin = dc.RightMargin = dc.BottomMargin = 19;
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];

        LiczDanePracownika(ph);
        RachunekBank.EditValue = pars.RachBank != null ? pars.RachBank : "&nbsp;";           
    }
	        
    public static void Msg(object obj) {
    }

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body style="font-family: Tahoma">
		<form id="DeklaracjaZ10" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.KadryPlace"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="OŚWIADCZENIE ZUS Z-10" runat="server"></cc1:reportheader>
			<FONT face="Tahoma" size="2">
            <p>
				<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" style="font-size: 10pt; font-family: tahoma">
					<TR>
						<TD width="100%" align="center"><b>OŚWIADCZENIE</b></TD>
					</TR>
                </TABLE>
                <b>Uwaga</b><br/>
                <b>Osoba, która złożyła oświadczenie do celów świadczenia rehabilitacyjnego na druku ZUS Np-7 wypełnia pkt 5 i 6, o ile informacje
                podane w oświadczeniu do celów świadczenia rehabilitacyjnego nie uległy zmianie.</b><br/>
            </p>
			</FONT>
			<P>
                <b>DANE IDENTYFIKACYJNE OSOBY UBIEGAJĄCEJ SIĘ O ZASIŁEK CHOROBOWY / ŚWIADCZENIE REHABILITACYJNE</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">01. Numer PESEL</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Rodzaj dokumentu (1-dowód osob., 2-inny dokument)<br />
                                                       03. Seria i numer dokumentu</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.PESEL" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD><FONT size="2">
				            <TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					            <TR>
						            <TD width="10%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                                        <ea:DataLabel id="DOKRODZAJ" runat="server"></ea:DataLabel>
                                    </TD>
						            <TD width="2%"></TD>
						            <TD width="88%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
							            <ea:DataLabel id="DOKUBEZP" runat="server"></ea:DataLabel>
                                    </TD>
                                </TR>
                            </TABLE>
                        </FONT></TD>
					</TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">04. Nazwisko</FONT></TD>
                    </TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.Nazwisko" runat="server"></ea:DataLabel></FONT></TD>
                    </TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">05. Imię</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">06. Data urodzenia (dd/mm/rrrr)</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.Imie" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="URODZONY" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Należy wpisać numer PESEL, a jeżeli nie nadano tego numeru, należy wpisać serię i numer dowodu osobistego albo innego dokumentu potwierdzającego tożsamość.
                </span>
            </P>
    	    <ea:PageBreak id="PageBreak32" runat="server" Required="False"></ea:PageBreak>
			<P>
                <b>DANE ADRESOWE OSOBY UBIEGAJĄCEJ SIĘ O ZASIŁEK CHOROBOWY / ŚWIADCZENIE REHABILITACYJNE - ADRES ZAMIESZKANIA</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">01. Kod pocztowy</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Poczta</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKodPocztowyS" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresPoczta" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD><FONT size="2">03. Gmina/Dzielnica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresGmina" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">04. Miejscowość</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">05. Ulica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="25%"><FONT size="2">06. Numer domu</FONT></TD>
						<TD width="1%"></TD>
						<TD width="22%"><FONT size="2">07. Numer lokalu</FONT></TD>
						<TD width="4%"></TD>
						<TD width="24%"><FONT size="2">08. Numer telefonu</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
						<TD width="1%"></TD>
						<TD width="23%"><FONT size="2">09. Symbol państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                2) 3)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresTelefon" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKodKraju" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">10. Zagraniczny kod pocztowy</FONT><FONT size="1"><span style="vertical-align: super">
                                2)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">11. Nazwa państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                2)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresZagranicznyKodPocztowy" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD width="48%"><FONT size="2">12. Adres poczty elektronicznej</FONT><FONT size="1"><span style="vertical-align: super">
                                1)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="AdresMail" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Podanie numeru telefonu i adresu poczty elektronicznej nie jest obowiązkowe.<br />
                    (2) Wypełnić w przypadku, gdy adres jest inny niż polski.<br />
                    (3) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.<br />
                </span>
			</P>
    	    <ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
            <p>
                W związku z roszczeniem o zasiłek chorobowy / świadczenie rehabilitacyjne<br />
                za okres po ustaniu tytułu ubezpieczenia chorobowego / wypadkowego<br />
                oświadczam, że:
            </p>
            </FONT>
			<ea:PageBreak id="PageBreak18" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
			<OL>
				<LI value="1">
				    <ea:DataLabel id="DataLabel5" runat="server" DataMember="PracHistoria.Plec" Bold="False">
					    <ValuesMap>
						    <ea:ValuesPair Key="Kobieta" Value="Złożyłam"></ea:ValuesPair>
						    <ea:ValuesPair Key="Mężczyzna" Value="Złożyłem"></ea:ValuesPair>
					    </ValuesMap>
				    </ea:DataLabel>
                    wniosek: o emeryturę / o rentę z tytułu niezdolności do pracy / o rentę z tytułu niezdolności do
                    służby / o wojskową rentę inwalidzką<br />
                    w . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . w dniu . . . . . . . . . . . . .<br />
			</OL>	
			</FONT>
			<ea:PageBreak id="PageBreak3" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
			<OL>
				<LI value="2">
                    Mam ustalone prawo do: emerytury / renty z tytułu niezdolności do pracy / renty z tytułu niezdolności do
                    służby / wojskowej renty inwalidzkiej<br />
                    przez . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . od dnia . . . . . . . . . . . . .<br />
                    Nr emerytury / renty . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
			</OL>	
			</FONT>
			<ea:PageBreak id="PageBreak4" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
			<OL>
				<LI value="3">
                    Mam ustalone prawo do: zagranicznej emerytury / renty z tytułu niezdolności do pracy<br />
                    przez . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . od dnia . . . . . . . . . . . . .<br />
			</OL>	
			</FONT>
			<ea:PageBreak id="PageBreak7" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
			<OL>
				<LI value="4">
                    Jestem
				    <ea:DataLabel id="DataLabel6" runat="server" DataMember="PracHistoria.Plec" Bold="False">
					    <ValuesMap>
						    <ea:ValuesPair Key="Kobieta" Value="uprawniona"></ea:ValuesPair>
						    <ea:ValuesPair Key="Mężczyzna" Value="uprawniony"></ea:ValuesPair>
					    </ValuesMap>
				    </ea:DataLabel>
                    do: zasiłku dla bezrobotnych / zasiłku przedemerytalnego / świadczenia przedemerytalnego /
                    nauczycielskiego świadczenia kompensacyjnego<br />
                    od dnia . . . . . . . . . . . . . . . .
			</OL>	
			</FONT>
			<ea:PageBreak id="PageBreak8" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
			<OL>
				<LI value="5">
                    Kontynuuję /
				    <ea:DataLabel id="DataLabel10" runat="server" DataMember="PracHistoria.Plec" Bold="False">
					    <ValuesMap>
						    <ea:ValuesPair Key="Kobieta" Value="podjęłam"></ea:ValuesPair>
						    <ea:ValuesPair Key="Mężczyzna" Value="podjąłem"></ea:ValuesPair>
					    </ValuesMap>
				    </ea:DataLabel>
                    również inną działalność zarobkową:<br /><br />
                    <ol>
                        a) prowadzę / małżonek prowadzi gospodarstwo rolne . . . . . . . . . . . o powierzchni . . . . . . . . . ha
                        przeliczeniowych lub dział specjalny. . . . . . . . . . . . . . . . . . . . ,<br />
                        b) podlegam obowiązkowo / dobrowolnie ubezpieczeniu społecznemu rolników . . . . . . . . . . . .,<br />
                        c) podlegam obowiązkowo / dobrowolnie ubezpieczeniu społecznemu rolników jako domownik rolnika . . . . . . . . . . . . . ,<br />
                        d) prowadzę działalność pozarolniczą . . . . . . . . . . . . . . . od dnia . . . . . . . . . . . . . . . . . . . . .,<br />
                        e) mam zawartą umowę o pracę . . . . . . . . . . . . . . . . . . od dnia . . . . . . . . . . . . . . . . . . . . .,<br />
                        f) w przypadku zatrudnienia u dwóch lub więcej pracodawców, należy podać, czy Pani/Pan korzystał
                        z urlopu bezpłatnego . . . . . . . . . . . . . . . . . . . od dnia . . . . . . . . . . . . . . . . . <br />do dnia. . . . . . . . . . . . . . . . . .,<br />
                        g) mam zawartą umowę zlecenia . . . . . . . . . . . . . . . . . od dnia . . . . . . . . . . . . . . . . . . . . .,<br />
                        h) wykonuję działalność zarobkową inną niż wymieniona w pkt a-g . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
                        . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                    </ol>
			</OL>	
			</FONT>
			<ea:PageBreak id="PageBreak9" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
			<OL>
				<LI value="6">
                    Jestem
				    <ea:DataLabel id="DataLabel11" runat="server" DataMember="PracHistoria.Plec" Bold="False">
					    <ValuesMap>
						    <ea:ValuesPair Key="Kobieta" Value="uprawniona"></ea:ValuesPair>
						    <ea:ValuesPair Key="Mężczyzna" Value="uprawniony"></ea:ValuesPair>
					    </ValuesMap>
				    </ea:DataLabel>
                    do dodatku szkoleniowego / stypendium / innego świadczenia pieniężnego<br />
                    wypłacanego przez powiatowy urząd pracy . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                    od dnia . . . . . . . . . . . . . . . . . . . . . . . . .<br />
			</OL>	
			</FONT>
			<ea:PageBreak id="PageBreak19" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
            <p>
                Proszę o wypłatę świadczenia na rachunek bankowy nr:<br />
                (Wypełnić jeżeli nie podano numeru konta wcześniej lub nastąpiła jego zmiana)
				<TABLE id="Table4" cellSpacing="0" cellPadding="0" width="100%" border="0" style="font-size: 10pt; font-family: tahoma">
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        	<ea:DataLabel id="RachunekBank" runat="server"></ea:DataLabel>
						</TD>
					</TR>
                </TABLE>
            </p>
            </FONT>
			<ea:PageBreak id="PageBreak10" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
            <p>
                <b>W przypadku zaistnienia jednej z wyżej wymienionych okoliczności albo w przypadku powstania tytułu do objęcia
                ubezpieczeniem chorobowym bądź zmiany miejsca zamieszkania w okresie pobierania zasiłku chorobowego lub
                świadczenia rehabilitacyjnego zobowiązuję się niezwłocznie powiadomić o tym Zakład Ubezpieczeń Społecznych.</b>            
            </p>
			</FONT>
			<ea:PageBreak id="PageBreak11" runat="server" Required="False"></ea:PageBreak>
			<FONT face="Tahoma" size="2">
            <p>
                Uwagi<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
                . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
            </p>
			</FONT>
            <ea:PageBreak id="PageBreak5" runat="server" Required="False"></ea:PageBreak></P>
			<FONT face="Tahoma" size="2">
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="(Miejscowość)" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="(Data: dd/mm/rrrr)" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="(Podpis osoby ubiegającej się o zasiłek chorobowy lub świadczenie rehabilitacyjne)" Width="33"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
            <br/><br/>
			</FONT>
			<ea:PageBreak id="PageBreak6" runat="server" Required="true"></ea:PageBreak></P>
			<FONT face="Tahoma" size="2">
			<P style="text-align: center"><FONT size="3"><b>POUCZENIE</b></FONT></P>
            <p style="text-align: justify">
                Zgodnie z art. 13 ust. 1, art. 18 i art. 22 ustawy z dnia 25 czerwca 1999 r. o świadczeniach pieniężnych z ubezpieczenia
                społecznego w razie choroby i macierzyństwa (Dz.U. z 2010 r. Nr 77, poz. 512 z późn. zm.) zasiłek chorobowy
                lub świadczenie rehabilitacyjne za okres po ustaniu tytułu ubezpieczenia chorobowego nie przysługuje
                osobie, która:<br />
                — ma ustalone prawo do emerytury lub renty z tytułu niezdolności do pracy,<br />
                — kontynuuje działalność zarobkową lub podjęła działalność zarobkową stanowiącą tytuł do objęcia obowiązkowo
                lub dobrowolnie ubezpieczeniem chorobowym albo zapewniającą prawo do świadczeń za
                okres niezdolności do pracy z powodu choroby,<br />
                — jest uprawniona do zasiłku dla bezrobotnych, zasiłku przedemerytalnego lub świadczenia przedemerytalnego,
                nauczycielskiego świadczenia kompensacyjnego,<br />
                — podlega obowiązkowo ubezpieczeniu społecznemu rolników.<br />
                Na podstawie art. 7 ustawy z dnia 30 października 2002 r. o ubezpieczeniu społecznym z tytułu wypadków
                przy pracy i chorób zawodowych (Dz.U. z 2009 r. Nr 167, poz. 1322 z późn. zm.) przepisy powyższe
                mają także zastosowanie do zasiłku chorobowego i świadczenia rehabilitacyjnego z ubezpieczenia wypadkowego.<br />
                W przypadku gdy osoba pobierająca zasiłek chorobowy lub świadczenie rehabilitacyjne za okres po ustaniu
                tytułu ubezpieczenia nie poinformuje o zaistnieniu okoliczności mających wpływ na prawo do tych
                świadczeń, świadczenia te, zgodnie z art. 84 ust. 1 i 2 ustawy z dnia 13 października 1998 r. o systemie
                ubezpieczeń społecznych (Dz.U. z 2009 r. Nr 205, poz. 1585 z późn. zm.) zostaną uznane za nienależnie
                pobrane i będą podlegały zwrotowi wraz z odsetkami w wysokości i na zasadach określonych w przepisach
                prawa cywilnego.<br/>
            </p>
            <p>
                <strong><span style="font-size: 2px"><span style="font-size: 9pt">ZUS-Z10<font size="2"><span></span></font></span></span></strong>
            </p>
		</font>
		</form>
	</body>
</HTML>
